### **实验名称**

聚类算法

### **实验目的**

1.了解聚类算法理论基础

2.编程实现聚类算法。

### **实验背景**

聚类分析起源于分类学，在古老的分类学中，人们主要依靠经验和专业知识来实现分类，很少利用数学工具进行定量的分类。随着人类科学技术的发展，对分类的要求越来越高，以致有时仅凭经验和专业知识难以确切地进行分类，于是人们逐渐地把数学工具引用到了分类学中，形成了数值分类学，之后又将多元分析的技术引入到数值分类学形成了聚类分析。聚类分析内容非常丰富，有系统聚类法、有序样品聚类法、动态聚类法、模糊聚类法、图论聚类法、聚类预报法等

### **实验原理**

#### 1. K 均值算法的原理

在各种聚类算法中，K 均值算法可以说是最简单的算法之一，但是简单不代表不好用。在大数据应用实践中，K 均值算法一般是在聚类中用得最多的算法之一。

K 均值算法的工作原理和步骤如下。

(1)产生数据集：假设数据集中的样本因为特征不同，像小圆点一样随机散布在地上。

(2)计算距离并确定簇：利用 K 均值算法计算小圆点之间的距离，并在小圆点聚集的地方插上旗子。

(3)求簇内样本均值：由于第一遍插的旗子并不能很完美地代表小圆点的分布，因此还要继续 K 均值计算，让每面旗子能够插到每堆小圆点聚集的最佳位置上，也就是数据点的均值上，这也是 K 均值聚类算法名字的由来。接下来一直重复上述的动作，直到找不出更好的位置

![4.jpg](./pic/4.jpg)

#### 2. DBSCAN 算法的原理

DBSCAN 是通过对特征空间内的密度进行检测的，密度较大的地方它会认为是一个类，而密度较小的地方它会认为是一个分界线。也正是这样的工作机制，使得 DBSCAN 算法不需要像 K 均值或者凝聚算法那样在一开始就指定聚类的数量 nclusters。 在理解 DBSCAN 算法的原理之前，需要了解它对数据的分类定义，针对有很多点的数据集，DBSCAN 算法将数据点分为以下 3 类。

- 核心点，在半径 eps 内含有超过指定数目 MinPts 的点。
- 边界点，点在半径 eps 内的数量小于指定数目 MinPts，但是落在核心点的邻域内。噪声点，既不是核心点也不是边界点的点。

其中，半径 eps 就是与某点 P 的距离小于等于特定值 eps 的所有的点的集合。另外还需要了解“密度直达” “密度可达”的概念。

- 密度直达(directly density-reachable):若某点 Q 处于核心点 P 的邻域内，则称 Q 由 P 密度直达。
- 密度可达(density-reachable):点 P、Q 均为核心点，如果处于 P 的邻域内，则称 Q 的邻域点由 P 密度可达。

了解以上的概念后，DBSCAN 算法的原理就相对好理解了，其工作原理和步骤如下:

(1)寻找核心点并形成聚类簇:在一个数据集中，任意两个样本点是“密度直达”或“密度可达”的关系，那么这两个样本点归为同一类。

(2)随机选择(1)中形成的聚类簇，遍历检查其内部的所有点是否为核心点，完成聚类簇的合并。

(3)遍历所有聚类簇，完成整个数据集的聚类。 下图所示的两个矩形框内的密集样本点被 DBSCAN 算法归为同一类。

![7.png](./pic/7.png)

### **实验环境**

Ubuntu 18.04

scikit-learn 0.18.1

python 3.9

jupyter notebook 6.1

### **建议课时**

4 课时

### **实验步骤**

环境准备：

双击打开桌面的“terminal”后，在命令行中输入如下命令，开启 jupyter notebook：

```python
jupyter notebook
```

打开 Jupter，点击右上角上的“New”按钮，选择“python3”创建文件。

![1721522453348.png](./pic/1721522453348.png)

#### 1\. 使用 K 均值算法进行简单聚类分析

**1) 利用 scikit-learn 生成数据集** 下面我们尝试用 scikit-leam 生成数据集来展示 K 均值算法的工作原理，输入代码 如下:

```python
#导入必要的库
from sklearn.datasets import make_blobs
import matplotlib.pyplot as plt
#生成分类数为1的数据集
data_stars = make_blobs(random_state=11,centers=1)
#将特征赋值给X
X_stars = data_stars[0]
#使用散点图进行可视化
plt.scatter(X_stars[:,0],X_stars[:,1],c='b',marker='*')
#显示图像
plt.show()
```

运行以上代码，生成一系列没有类别(无标签)的数据点(以五角星表示)，并且用散点图把它们画出来，结果如图所示：

![5.png](./pic/5.png)

使用 make_blobs 生成无标签数据

从上图中我们可以看到，由于我们指定了 make_blobs 的 centers 参数为 1，因此所有的数据都属于 1 类，并没有差别。

**2) 用 K 均值算法建立模型进行聚类分析** 下面我们使用 K 均值算法来对这些数据进行聚类，输入代码如下:

```python
#导入KMeans工具
from sklearn.cluster import KMeans
#导入numpy
import numpy as np

#要求KMeans将数据聚为4类
kmeans = KMeans(n_clusters=4)
#拟合数据
kmeans.fit(X_stars)

#下面的代码是用来绘图的，这里我们不展开解释
x_min, x_max = X_stars[:, 0].min()-0.5 , X_stars[:, 0].max()+0.5
y_min, y_max = X_stars[:, 1].min()-0.5 , X_stars[:, 1].max()+0.5
xx, yy = np.meshgrid(np.arange(x_min, x_max, .02),
                     np.arange(y_min, y_max, .02))
Z = kmeans.predict(np.c_[xx.ravel(), yy.ravel()])
Z = Z.reshape(xx.shape)
plt.figure(1)
plt.clf()
plt.imshow(Z, interpolation='nearest',
           extent=(xx.min(), xx.max(), yy.min(), yy.max()),
           cmap=plt.cm.Pastel2,
           aspect='auto', origin='lower')

plt.plot(X_stars[:, 0], X_stars[:, 1], 'r.', markersize=6,marker='*',c='b')
#用红色大星代表聚类的中心
centroids = kmeans.cluster_centers_
plt.scatter(centroids[:, 0], centroids[:, 1],
            marker='*', s=150, linewidths=3,
            color='r', zorder=10)

plt.xlim(x_min, x_max)
plt.ylim(y_min, y_max)
plt.xticks(())
plt.yticks(())
#显示图像
plt.show()
```

运行代码我们会得到如图所示的结果（此处每次运行结果根据 sklearn 版本会有不同，仅作演示）：

![6.png](./pic/6.png)

使用 K 均值算法进行聚类

在上述代码中，我们指定了 K 均值算法的 n 类参数是 4，所以 K 均值算法将数据点聚类为 4 类，图中有 4 个红色的五角星代表了 K 均值算法对数据进行聚类的 4 个中心。 那么 K 均值算法怎样来表示这些聚类?可以输入下面代码来看看:

```python
#打印KMeans进行聚类的标签
print("K均值的聚类标签:\n{}".format(kmeans.labels_))
```

输出结果如下（根据上面的运行结果下面也会同步改变）：

```markup
K均值的聚类标签:
[3 2 2 1 2 2 2 2 1 1 1 0 1 2 3 1 1 2 1 1 3 3 2 1 2 3 3 3 0 2 0 3 1 1 1 2 3
 0 2 2 2 3 2 3 1 0 2 1 3 1 2 2 1 0 2 0 3 1 1 2 0 0 2 2 3 0 2 3 0 3 2 3 3 2
 3 3 3 3 0 3 3 3 0 0 0 3 2 3 1 2 3 1 2 1 1 3 3 3 0 1]
```

从上述结果中我们可以看到，K 均值算法对数据进行的聚类和分类有些类似，是用 0、1、2、3 这 4 个数字来代表数据的类，并且储存在.labels 属性中。通过以上过程来看,K 均值算法十分简单而且容易理解，但它也有很明显的局限性例如，它认为每个数据点到聚类中心的方向都是同等重要的。这样一来，对于"形状"复杂的数据集来说，K 均值算法就不能很好地工作。

#### 2\. 使用 DBSCAN 算法进行简单聚类分析

下面我们通过 scikit-leam 随机生成数据集，使用 DBSCAN 算法进行简单聚类分析。

**1）生成圆环嵌套型数据集**

使用 scilkit-learn 库中的 make circles 生成圆环嵌套型的样本数据集，输入代码如下:

```python
#导入scikit-learn库
import matplotlib.pyplot as plt
from sklearn import datasets
import matplotlib.colors

#创建Figure
fig=plt.figure(figsize=(10,5))
#生成圆环嵌套型数据集，样本数量为500
X_cir,y_cir=datasets.make_circles(n_samples=500,factor=.6,
                                  noise=0.05,random_state=42)
#绘制圆环嵌套图
plt.scatter(X_cir[:,0],X_cir[:,1],marker="o",c='g',s=60,edgecolor="k")
plt.title("make_circles Datasets")
#设置横、纵轴标签
plt.xlabel("Feature 0")
plt.ylabel("Feature 1")
#显示图形
plt.show()
```

运行代码我们会得到如图所示的结果:

![8.png](./pic/8.png)

生成圆环嵌套型数据集

从上图中看到，使用 make_circles 生成了圆环套型数据集。对于 DBSCAN 算法圆环嵌套型数据集能够很好地帮助我们观察模型对它的聚类情况。

**2）使用不带参数的 DBSCAN 进行聚类**

对圆环嵌套型数据集进行拟合，来展示 DBSCAN 的工作机制，输入代码如下:

```python
#导入DBSCAB
from sklearn.cluster import DBSCAN
#使用DBSCAN拟合数据，默认参数
db=DBSCAN()
cluster=db.fit_predict(X_cir)
#绘制圆环嵌套图
plt.scatter(X_cir[:,0],X_cir[:,1],marker="o",
                  c=cluster,s=60,edgecolor="k",cmap=plt.cm.cool)
plt.title("DBSCAN Cluster")
#设置横、纵轴标签
plt.xlabel("Feature 0")
plt.ylabel("Feature 1")
#显示图形
plt.show()
```

运行代码,结果如图所示:

![9.png](./pic/9.png)

不带参数的 DBSCAN 聚类

从上图可知，所有的数据点都变成了浅色，这并不是表明所有数据点都变成了噪声，而是所有的数据点都被归入同一类。这是因为在参数默认的情况下，DBSCAN 把所有数据点都拉到同一类中了。

**3）调整 DBSCAN 参数提升聚类效果**

接下来我们需要了解 DBSCAN 中两个非常重要的参数，一是 eps 参数，另一个是 min samples 参数。下面通过运行代码分别了解这两个参数的作用和效果。

(1)eps 参数

eps 参数指定的是考虑划入同一类的样本距离有多远，eps 值设置得越大，则聚类所覆盖的数据点越多，否则越少。默认情况下 eps 值为 0.5。针对这个圆环嵌套型数据集，我们试着把 eps 值调小一些，看看会发生什么。输入代码如下:

```python
#导入DBSCAB
from sklearn.cluster import DBSCAN
#使用DBSCAN拟合数据，默认参数
db=DBSCAN(eps=0.12)
cluster_eps=db.fit_predict(X_cir)
#绘制圆环嵌套图
plt.scatter(X_cir[:,0],X_cir[:,1],marker="o",
                  c=cluster_eps,s=60,edgecolor="k",cmap=plt.cm.cool)
plt.title("DBSCAN Cluster(eps=0.12)")
#设置横、纵轴标签
plt.xlabel("Feature 0")
plt.ylabel("Feature 1")
#显示图形
plt.show()
```

在这段代码中，我们手动指定了 eps 值为 0.12，运行代码得到图 10 所示的结果。

![10.png](./pic/10.png)

不带参数的 DBSCAN 聚类

我们看到经过 DBSCAN 的聚类，数据点被标成了几种不同深浅颜色的点。那么是不是表示 DBSCAN 把数据聚类成了这几类呢?我们可以尝试输出数据集的标签，输入代码如下:

```python
#打印聚类个数
print('\n\n\nDBSCAN聚类(eps=0.12)的标签为：\n{}\n\n\n'.format(cluster_eps))
```

![r2.jpg](./pic/r2.jpg)

我们从结果中发现，在聚类标签中出现了-1 这样的值，这是怎么回事呢?原来在 DBSCAN 中，-1 代表该数据点是噪声。在不带参数的 DBSCAN 聚类图中，我们看到两类深色的数据点密度相对较大，因此 DBSCAN 把它们分别归到各自的一类:而周边比较散乱的、浅色的数据点，DBSCAN 认为它们不属于任何一类，所以放进了“噪声”这个类别。

(2)min_samples

参数 min_samples 参数指定的是在某个数据点周围被看成聚类核心点的个数 min_samples 值越大，则核心数据点越少，噪声也就越多;反之 min_sample 值越小，噪声也就越少。默认的 min_samples 值是 2。下面我们调整 min_samples 参数，再用图形展示看看效果，输入代码如下:

```python
#导入DBSCAB
from sklearn.cluster import DBSCAN
#使用DBSCAN拟合数据，默认参数
db_1=DBSCAN(min_samples=103)
cluster_1=db_1.fit_predict(X_cir)
#绘制圆环嵌套图
plt.scatter(X_cir[:,0],X_cir[:,1],marker="o",
                  c=cluster_1,s=60,edgecolor="k",cmap=plt.cm.cool)
plt.title("DBSCAN Cluster(min_samples=103)")
#设置横、纵轴标签
plt.xlabel("Feature 0")
plt.ylabel("Feature 1")
#显示图形
plt.show()
```

现在我们指定 min_samples 的值为 103，运行代码，得到下图所示的结果。

![11.png](./pic/11.png)

min_samples 为 103 的 DBSCAN 聚类 对比上面两图，我们会发现，参数不同，对聚类的的归类也不同。

同时调整 eps 和 min_samples 参数，输入代码如下:

```python
#导入DBSCAB
from sklearn.cluster import DBSCAN
#使用DBSCAN拟合数据，默认参数
db_2=DBSCAN(eps=0.15,min_samples=18)
cluster_2=db_2.fit_predict(X_cir)
#绘制圆环嵌套图
plt.scatter(X_cir[:,0],X_cir[:,1],marker="o",
                  c=cluster_2,s=60,edgecolor="k",cmap=plt.cm.cool)
plt.title("DBSCAN Cluster(eps=0.15,min_samples=18)")
#设置横、纵轴标签
plt.xlabel("Feature 0")
plt.ylabel("Feature 1")
#显示图形
plt.show()
```

![图12 eps=0.15，min_samples=18的DBSCAN聚类](./pic/12.png)

eps=0.15，min_samples=18 的 DBSCAN 聚类

通过对 eps 和 min_samples 参数的不断调整，我们发现，对于圆环嵌套型的数据集,eps=0.15 结合 min_samples=18，使数据拟合得比较好，基本能够把两个圆环相对完整地区别开来，聚类效果不错， 根据上述的试验,虽然 DBSCAN 并不需要我们在开始训练算法的时候就指定 clusters 的数量,但是通过对 eps 和 min_samples 参数赋值,相当于间接地指定了 clusters 的数量。eps 参数尤为重要，因为它规定了某一类的范围大小。而且在实际应用中，如果将数据集先用 MinMaxScaler 或者 StandardScaler 进行预处理，那么 DBSCAN 算法的表现会更好(因为这两种预处理方法把数据的范围控制得比较集中)。

### **实验总结**

通过对 k 均值和 DBSCAN 算法的介绍，从而对聚类算法的应用有更深的了解。
